IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SNGPC_MOVIMENTOS_PENDENTE]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[SNGPC_MOVIMENTOS_PENDENTE](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[DT_MOVIMENTO] [datetime] NOT NULL,
	[QT_ENTRADAS] [int] NOT NULL,
	[QT_VENDAS] [int] NOT NULL,
	[QT_SAIDAS] [int] NOT NULL,
	[QT_TRANSF] [int] NOT NULL,
	[QT_PERDAS] [int] NOT NULL,
	[DT_ULT_ARQUIVO] [datetime] NULL,
	[DT_ULT_VALIDADO] [datetime] NULL,
	[DT_REINICIO] [datetime] NULL,
	[QT_REINICIO] [int] NOT NULL,
	[DT_CAD] [datetime] NULL,
 CONSTRAINT [PK_SNGPC_MOVIMENTOS_PENDENTE] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[SNGPC_MOVIMENTOS_PENDENTE] ADD  CONSTRAINT [DF_SNGPC_MOVIMENTOS_PENDENTE_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[SNGPC_MOVIMENTOS_PENDENTE] ADD  CONSTRAINT [DF_SNGPC_MOVIMENTOS_PENDENTE_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[SNGPC_MOVIMENTOS_PENDENTE] ADD  CONSTRAINT [DF_SNGPC_MOVIMENTOS_PENDENTE_QT_ENTRADAS]  DEFAULT ((0)) FOR [QT_ENTRADAS]

ALTER TABLE [dbo].[SNGPC_MOVIMENTOS_PENDENTE] ADD  CONSTRAINT [DF_SNGPC_MOVIMENTOS_PENDENTE_QT_VENDAS]  DEFAULT ((0)) FOR [QT_VENDAS]

ALTER TABLE [dbo].[SNGPC_MOVIMENTOS_PENDENTE] ADD  CONSTRAINT [DF_SNGPC_MOVIMENTOS_PENDENTE_QT_SAIDAS]  DEFAULT ((0)) FOR [QT_SAIDAS]

ALTER TABLE [dbo].[SNGPC_MOVIMENTOS_PENDENTE] ADD  CONSTRAINT [DF_SNGPC_MOVIMENTOS_PENDENTE_QT_TRANSF]  DEFAULT ((0)) FOR [QT_TRANSF]

ALTER TABLE [dbo].[SNGPC_MOVIMENTOS_PENDENTE] ADD  CONSTRAINT [DF_SNGPC_MOVIMENTOS_PENDENTE_QT_PERDAS]  DEFAULT ((0)) FOR [QT_PERDAS]

ALTER TABLE [dbo].[SNGPC_MOVIMENTOS_PENDENTE] ADD  CONSTRAINT [DF_SNGPC_MOVIMENTOS_PENDENTE_QT_REINICIO]  DEFAULT ((0)) FOR [QT_REINICIO]

ALTER TABLE [dbo].[SNGPC_MOVIMENTOS_PENDENTE] ADD  CONSTRAINT [DF_SNGPC_MOVIMENTOS_PENDENTE_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]
END